/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FileConfigContainer;
import com.iafenvoy.jupiter.config.container.wrapper.RemoteConfigWrapper;
import com.iafenvoy.jupiter.network.ClientConfigNetwork;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ConfigSelectScreen
extends class_437
implements JupiterScreen {
    private final class_437 parent;
    @Nullable
    private final AbstractConfigContainer common;
    @Nullable
    private final AbstractConfigContainer client;
    @Nullable
    private final AbstractConfigContainer server;
    private final boolean displayCommon;

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public ConfigSelectScreen(class_2561 title, class_437 parent, @Nullable FileConfigContainer serverConfig, @Nullable FileConfigContainer clientConfig) {
        super(title);
        this.parent = parent;
        this.server = serverConfig;
        this.client = clientConfig;
        this.common = null;
        this.displayCommon = false;
    }

    protected ConfigSelectScreen(class_2561 title, class_437 parent, @Nullable AbstractConfigContainer common, @Nullable AbstractConfigContainer client, @Nullable AbstractConfigContainer server, boolean displayCommon) {
        super(title);
        this.parent = parent;
        this.common = common;
        this.client = client;
        this.server = server;
        this.displayCommon = displayCommon;
    }

    protected void method_25426() {
        super.method_25426();
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        this.method_37063((class_364)JupiterScreen.createButton(x - 100, y - (this.displayCommon ? 60 : 45), 200, 20, (class_2561)TextUtil.translatable("jupiter.screen.back", new Object[0]), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }));
        if (this.displayCommon) {
            Pair<class_4185, Consumer<class_2561>> commonPair = JupiterScreen.createButtonWithDynamicTooltip(this, x - 100, y - 30, 200, 20, (class_2561)TextUtil.translatable("jupiter.screen.common_config", new Object[0]), button -> {
                assert (this.field_22787 != null && this.common != null);
                this.field_22787.method_1507(JupiterScreen.getConfigScreen(this, this.common, false));
            }, (class_2561)TextUtil.translatable("jupiter.screen.unavailable", new Object[0]));
            boolean bl = ((class_4185)this.method_37063((class_364)((class_4185)commonPair.getFirst()))).field_22763 = this.common != null;
            if (this.common != null) {
                ConfigSelectScreen.handleRemoteConfig(this.common, "jupiter.screen.open_common", b -> {
                    ((class_4185)commonPair.getFirst()).field_22763 = b;
                }, (Consumer)commonPair.getSecond());
            }
        }
        Pair<class_4185, Consumer<class_2561>> serverPair = JupiterScreen.createButtonWithDynamicTooltip(this, x - 100, y - (this.displayCommon ? 0 : 15), 200, 20, (class_2561)TextUtil.translatable("jupiter.screen.server_config", new Object[0]), button -> {
            assert (this.field_22787 != null && this.server != null);
            this.field_22787.method_1507(JupiterScreen.getConfigScreen(this, this.server, false));
        }, (class_2561)TextUtil.translatable("jupiter.screen.unavailable", new Object[0]));
        boolean bl = ((class_4185)this.method_37063((class_364)((class_4185)serverPair.getFirst()))).field_22763 = this.server != null;
        if (this.server != null) {
            ConfigSelectScreen.handleRemoteConfig(this.server, "jupiter.screen.open_server", b -> {
                ((class_4185)serverPair.getFirst()).field_22763 = b;
            }, (Consumer)serverPair.getSecond());
        }
        class_4185 clientButton = (class_4185)this.method_37063((class_364)JupiterScreen.createButtonWithTooltip(this, x - 100, y + (this.displayCommon ? 30 : 15), 200, 20, (class_2561)TextUtil.translatable("jupiter.screen.client_config", new Object[0]), button -> {
            assert (this.field_22787 != null);
            assert (this.client != null);
            this.field_22787.method_1507(JupiterScreen.getConfigScreen(this, this.client, true));
        }, (class_2561)TextUtil.translatable(this.client != null ? "jupiter.screen.open_client" : "jupiter.screen.unavailable", new Object[0])));
        clientButton.field_22763 = this.client != null;
    }

    private static void handleRemoteConfig(AbstractConfigContainer container, String openKey, BooleanConsumer buttonActive, Consumer<class_2561> tooltip) {
        if (JupiterScreen.connectedToDedicatedServer()) {
            tooltip.accept((class_2561)TextUtil.translatable("jupiter.screen.check_server", new Object[0]));
            buttonActive.accept(false);
            ClientConfigNetwork.syncConfig(container.getConfigId(), nbt -> {
                if (nbt == null) {
                    tooltip.accept((class_2561)TextUtil.translatable("jupiter.screen.disable_server", new Object[0]));
                } else {
                    try {
                        container.deserializeNbt((class_2487)nbt);
                        tooltip.accept((class_2561)TextUtil.translatable(openKey, new Object[0]));
                        buttonActive.accept(true);
                    }
                    catch (Exception e) {
                        Jupiter.LOGGER.error("Failed to parse config data from server: {}", (Object)container.getConfigId(), (Object)e);
                        tooltip.accept((class_2561)TextUtil.translatable("jupiter.screen.error_server", new Object[0]));
                    }
                }
            });
        } else {
            tooltip.accept((class_2561)TextUtil.translatable(openKey, new Object[0]));
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        assert (this.field_22787 != null);
        graphics.method_27534(this.field_22787.field_1772, this.field_22785, this.field_22789 / 2, this.field_22790 / 2 - (this.displayCommon ? 80 : 65), -1);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return true;
    }

    public static Builder builder(String titleKey, class_437 parent) {
        return new Builder(titleKey, parent);
    }

    public static Builder builder(class_2561 title, class_437 parent) {
        return new Builder(title, parent);
    }

    public static class Builder {
        private final class_2561 title;
        private final class_437 parent;
        private AbstractConfigContainer common;
        private AbstractConfigContainer client;
        private AbstractConfigContainer server;
        private boolean displayCommon = false;

        public Builder(String titleKey, class_437 parent) {
            this((class_2561)TextUtil.translatable(titleKey, new Object[0]), parent);
        }

        public Builder(class_2561 title, class_437 parent) {
            this.title = title;
            this.parent = parent;
        }

        public Builder common(AbstractConfigContainer common) {
            this.common = JupiterScreen.connectedToDedicatedServer() ? new RemoteConfigWrapper(common) : common;
            return this.displayCommon();
        }

        public Builder displayCommon() {
            this.displayCommon = true;
            return this;
        }

        public Builder client(AbstractConfigContainer client) {
            this.client = client;
            return this;
        }

        public Builder server(AbstractConfigContainer server) {
            this.server = JupiterScreen.connectedToDedicatedServer() ? new RemoteConfigWrapper(server) : server;
            return this;
        }

        public ConfigSelectScreen build() {
            return new ConfigSelectScreen(this.title, this.parent, this.common, this.client, this.server, this.displayCommon);
        }
    }
}

